package com.example.gpstest;

import java.util.Calendar;
import java.util.Iterator;

import android.location.Criteria;
import android.location.GpsSatellite;
import android.location.GpsStatus;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.location.LocationProvider;
import android.os.Bundle;
import android.provider.Settings;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import android.view.Menu;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

public class MainActivity extends Activity {

	private EditText editText;
    private TextView logText;
    private LocationManager lm;
    private static final String TAG="GpsActivity";
	 @Override
	 protected void onDestroy() {
	  // TODO Auto-generated method stub
	  super.onDestroy();
	  lm.removeUpdates(locationListener);
	 }
 
 
 private void setLog(String txt){
	 printTime();
	 setLogInfo(txt);
 }
 
 private void setLogInfo(String txt){
	 logText.setText(txt+"\n"+"--------------------\n"+logText.getText());
 }
 
 private void printTime(){
	 Calendar ca = Calendar.getInstance();
     int year = ca.get(Calendar.YEAR);//获取年份
     int month=ca.get(Calendar.MONTH);//获取月份 
     int day=ca.get(Calendar.DATE);//获取日
     int minute=ca.get(Calendar.MINUTE);//分 
     int hour=ca.get(Calendar.HOUR);//小时 
     int second=ca.get(Calendar.SECOND);//秒
     int WeekOfYear = ca.get(Calendar.DAY_OF_WEEK); 
     
     
     setLogInfo(getString(R.string.info_current_date) + year +"-"
    		 + month +"-"+ day);
     setLogInfo(">>>" + hour +":"+ minute 
    		 +":"+ second);
 }
 
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        
        editText=(EditText)findViewById(R.id.editText);
        logText=(TextView) this.findViewById(R.id.logText);
        
        
        lm=(LocationManager)getSystemService(Context.LOCATION_SERVICE);
        
        //判断GPS是否正常启动
        if(!lm.isProviderEnabled(LocationManager.GPS_PROVIDER)){
            Toast.makeText(this, getString(R.string.info_open_gps), Toast.LENGTH_SHORT).show();
            setLog(getString(R.string.info_open_gps));
            //返回开启GPS导航设置界面
            Intent intent = new Intent(Settings.ACTION_LOCATION_SOURCE_SETTINGS);   
            startActivityForResult(intent,0); 
            return;
        }
        
        //为获取地理位置信息时设置查询条件
        String bestProvider = lm.getBestProvider(getCriteria(), true);
        //获取位置信息
        //如果不设置查询要求，getLastKnownLocation方法传人的参数为LocationManager.GPS_PROVIDER
        Location location= lm.getLastKnownLocation(bestProvider);    
        updateView(location);
        //监听状态
        lm.addGpsStatusListener(listener);
        //绑定监听，有4个参数    
        //参数1，设备：有GPS_PROVIDER和NETWORK_PROVIDER两种
        //参数2，位置信息更新周期，单位毫秒    
        //参数3，位置变化最小距离：当位置距离变化超过此值时，将更新位置信息    
        //参数4，监听    
        //备注：参数2和3，如果参数3不为0，则以参数3为准；参数3为0，则通过时间来定时更新；两者为0，则随时刷新   
        
        // 1秒更新一次，或最小位移变化超过1米更新一次；
        //注意：此处更新准确度非常低，推荐在service里面启动一个Thread，在run中sleep(10000);然后执行handler.sendMessage(),更新位置
        lm.requestLocationUpdates(LocationManager.GPS_PROVIDER, 1000, 1, locationListener);
    }
    
    //位置监听
    private LocationListener locationListener=new LocationListener() {
        
        /**
         * 位置信息变化时触发
         */
        public void onLocationChanged(Location location) {
            updateView(location);
            Log.i(TAG, getString(R.string.info_time)+location.getTime()); 
            Log.i(TAG, getString(R.string.info_longitude)+location.getLongitude()); 
            Log.i(TAG, getString(R.string.info_latitude)+location.getLatitude()); 
            Log.i(TAG, getString(R.string.info_altitude)+location.getAltitude()); 
            
            
            setLog( getString(R.string.info_time)+location.getTime());
            setLog( getString(R.string.info_longitude)+location.getLongitude());
            setLog( getString(R.string.info_latitude)+location.getLatitude());
            setLog( getString(R.string.info_altitude)+location.getAltitude());
        }
        
        /**
         * GPS状态变化时触发
         */
        public void onStatusChanged(String provider, int status, Bundle extras) {
            switch (status) {
            //GPS状态为可见时
            case LocationProvider.AVAILABLE:
                Log.i(TAG,getString(R.string.info_gps_visible));
                
                setLog(getString(R.string.info_gps_visible));
                break;
            //GPS状态为服务区外时
            case LocationProvider.OUT_OF_SERVICE:
                Log.i(TAG, getString(R.string.info_gps_out));
                setLog(getString(R.string.info_gps_out));
                break;
            //GPS状态为暂停服务时
            case LocationProvider.TEMPORARILY_UNAVAILABLE:
                Log.i(TAG, getString(R.string.info_gps_pause));
                setLog(getString(R.string.info_gps_pause));
                break;
            }
        }
    
        /**
         * GPS开启时触发
         */
        public void onProviderEnabled(String provider) {
            Location location=lm.getLastKnownLocation(provider);
            updateView(location);
        }
    
        /**
         * GPS禁用时触发
         */
        public void onProviderDisabled(String provider) {
            updateView(null);
        }
 
    
    };
    
    //状态监听
    GpsStatus.Listener listener = new GpsStatus.Listener() {
        public void onGpsStatusChanged(int event) {
            switch (event) {
            //第一次定位
            case GpsStatus.GPS_EVENT_FIRST_FIX:
                Log.i(TAG, getString(R.string.info_first_positioning));
                setLog(getString(R.string.info_first_positioning));
                break;
            //卫星状态改变
            case GpsStatus.GPS_EVENT_SATELLITE_STATUS:
                Log.i(TAG, getString(R.string.info_satellite_state_change));
                setLog(getString(R.string.info_satellite_state_change));
                //获取当前状态
                GpsStatus gpsStatus=lm.getGpsStatus(null);
                //获取卫星颗数的默认最大值
                int maxSatellites = gpsStatus.getMaxSatellites();
                //创建一个迭代器保存所有卫星 
                Iterator<GpsSatellite> iters = gpsStatus.getSatellites().iterator();
                int count = 0;     
                while (iters.hasNext() && count <= maxSatellites) {     
                    GpsSatellite s = iters.next();     
                    count++;     
                }   
                System.out.println(getString(R.string.info_find)+count+getString(R.string.info_satellite));
                setLog(getString(R.string.info_find)+count+getString(R.string.info_satellite));
                break;
            //定位启动
            case GpsStatus.GPS_EVENT_STARTED:
                Log.i(TAG, getString(R.string.info_posution_start));
                setLog(getString(R.string.info_posution_start));
                break;
            //定位结束
            case GpsStatus.GPS_EVENT_STOPPED:
                Log.i(TAG, getString(R.string.info_posution_stop));
                setLog(getString(R.string.info_posution_stop));
                break;
            }
        };
    };
    
    /**
     * 实时更新文本内容
     * 
     * @param location
     */
    private void updateView(Location location){
        if(location!=null){
            editText.setText(getString(R.string.info_location)+"\n\n"+getString(R.string.info_longitude));
            editText.append(String.valueOf(location.getLongitude()));
            editText.append("\n"+getString(R.string.info_latitude));
            editText.append(String.valueOf(location.getLatitude()));
        }else{
            //清空EditText对象
            editText.getEditableText().clear();
        }
    }
    
    /**
     * 返回查询条件
     * @return
     */
    private Criteria getCriteria(){
        Criteria criteria=new Criteria();
        //设置定位精确度 Criteria.ACCURACY_COARSE比较粗略，Criteria.ACCURACY_FINE则比较精细 
        criteria.setAccuracy(Criteria.ACCURACY_FINE);    
        //设置是否要求速度
        criteria.setSpeedRequired(false);
        // 设置是否允许运营商收费  
        criteria.setCostAllowed(false);
        //设置是否需要方位信息
        criteria.setBearingRequired(false);
        //设置是否需要海拔信息
        criteria.setAltitudeRequired(false);
        // 设置对电源的需求  
        criteria.setPowerRequirement(Criteria.POWER_LOW);
        return criteria;
    }

}
